#!/bin/tcsh
set path = ($path /data/brutus_data0/freeware/afni)
echo $path

foreach subj (s001 s002)
#foreach subj (001 ... n00)

#1.auditory

set prefix_3dd = Ad_
cd /data/.../FC_reho_SB_DR/rsfMRIStudy/${subj}/${subj}.results
set stmdir = /data/.../FC_reho_SB_DR/DR_rsFC/Data_ats

echo '***************' ${subj} '*************** '

# --------------------------
# ------ regression analysis
3dTproject -polort 2 -ort $stmdir/ats_adn.1D \
        -input errts.${subj}.fanaticor+tlrc.HEAD -prefix ${prefix_3dd}errts.${subj}

#2.attention

set prefix_3dd = At_
# --------------------------
# -----  regression analysis
3dTproject -polort 2 -ort $stmdir/ats_atn.1D \
        -input errts.${subj}.fanaticor+tlrc.HEAD -prefix ${prefix_3dd}errts.${subj}

#3.default-mode

set prefix_3dd = Dm_
# --------------------------
# -----  regression analysis
3dTproject -polort 2 -ort $stmdir/ats_dmn.1D \
        -input errts.${subj}.fanaticor+tlrc.HEAD -prefix ${prefix_3dd}errts.${subj}

#4.executive-control

set prefix_3dd = Ec_
# ----------------------------
# -------- regression analysis
3dTproject -polort 2 -ort $stmdir/ats_ecn.1D \
        -input errts.${subj}.fanaticor+tlrc.HEAD -prefix ${prefix_3dd}errts.${subj}

#5.fronto-parietal

set prefix_3dd = Fp_
# ----------------------------
# -------- regression analysis
3dTproject -polort 2 -ort $stmdir/ats_atn.1D \
        -input errts.${subj}.fanaticor+tlrc.HEAD -prefix ${prefix_3dd}errts.${subj}

#6.salience

set prefix_3dd = Sl_
# ------------------------------
# ---------- regression analysis
3dTproject -polort 2 -ort $stmdir/ats_sln.1D \
        -input errts.${subj}.fanaticor+tlrc.HEAD -prefix ${prefix_3dd}errts.${subj}

#7.sensorimotor

set prefix_3dd = Sm_
# ------------------------------
# ---------- regression analysis
3dTproject -polort 2 -ort $stmdir/ats_smn.1D \
        -input errts.${subj}.fanaticor+tlrc.HEAD -prefix ${prefix_3dd}errts.${subj}

#8.visual

set prefix_3dd = Vs_
# ------------------------------
# ---------- regression analysis
3dTproject -polort 2 -ort $stmdir/ats_vsn.1D \
        -input errts.${subj}.fanaticor+tlrc.HEAD -prefix ${prefix_3dd}errts.${subj}
end



